%This script generates Fig. OA.6, OA.7, and OA.8.

%Parameters
N=2;
T=1000000;
grid_middle = 5;
grid_size= 3;  
tick= 1;      

%% Figure OA.6: Baseline Case

%Read the data generated by script_simulation
last_episodes = readmatrix('Data/last_episodes.txt');
av_all_episodes = readmatrix('Data/av_all_episodes.txt');

%Panel A: PRICE OF AMM 1 IN LAST EPISODE - HISTOGRAM
figure(1);
    [C,~,ic] = unique(last_episodes(:,1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xticks(0:1:15); %Ticks when the tick size is 1
    xlim([grid_middle - grid_size*tick-(9/10)*tick, grid_middle + grid_size*tick+(9/10)*tick]);%the (9/10) is so that the bars at 2 and 8 (if any) do not appear clipped, 
    %without displaying 1 and 9 which are not on the grid
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Price of $AM_1$ in last episode','interpreter', 'latex')

%save png
filename = sprintf('/Figures/Fig_OA_6_a.png'); 
saveas(figure(1), [pwd filename]);

close(figure(1))

%Panel B: AVERAGE PROFIT OF PLAYER 1 OVER EPISODES
figure(2)

% plot average profit of player 1
% the profit of AMM1 is in column 5
x = (1:T)';
plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared profit of AMM1 is in column 12
upper = movmean(av_all_episodes(:,5) + sqrt(av_all_episodes(:,12)-av_all_episodes(:,5).^2),500);  
lower = movmean(av_all_episodes(:,5) - sqrt(av_all_episodes(:,12)-av_all_episodes(:,5).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'southeast')
legend('boxoff')
ylabel('Profit of $AM_1$','interpreter', 'latex')
xlabel('Episodes')

ylim([-1,1]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_OA_6_b.png');
saveas(figure(2), [pwd filename]);
close(figure(2))


%% Figure OA.7: Exclusion strategy

%Read the data generated by script_simulation_exclusion
last_episodes = readmatrix('Data/last_episodes_exclusion.txt');
av_all_episodes = readmatrix('Data/av_all_episodes_exclusion.txt');

%Panel A: PRICE OF AM IN LAST EPISODE - HISTOGRAM

figure(3);
    [C,~,ic] = unique(last_episodes(:,1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xticks(0:1:15); %Ticks when the tick size is 1
    xlim([grid_middle - grid_size*tick-(9/10)*tick, grid_middle + grid_size*tick+(9/10)*tick]);%the (9/10) is so that the bars at 2 and 8 (if any) do not appear clipped, 
    %without displaying 1 and 9 which are not on the grid
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Price of AM in last episode')

%save png
filename = sprintf('/Figures/Fig_OA_7_a.png'); 
saveas(figure(3), [pwd filename]);

close(figure(3))

%Panel C: PRICE OF OM IN LAST EPISODE - HISTOGRAM

figure(4);
    [C,~,ic] = unique(last_episodes(:,2));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xticks(0:1:15); %Ticks when the tick size is 1
    xlim([grid_middle - grid_size*tick-(9/10)*tick, grid_middle + grid_size*tick+(9/10)*tick]);%the (9/10) is so that the bars at 2 and 8 (if any) do not appear clipped, 
    %without displaying 1 and 9 which are not on the grid
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Price of OM in last episode')

%save png
filename = sprintf('/Figures/Fig_OA_7_c.png'); 
saveas(figure(4), [pwd filename]);

close(figure(4))

%Panel B: AVERAGE PROFIT OF AM OVER EPISODES
figure(5)

% plot average profit of player 1
x = (1:T)';
plot(x,av_all_episodes(:,4) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared profit of AM is in column 10
upper = movmean(av_all_episodes(:,4) + sqrt(av_all_episodes(:,10)-av_all_episodes(:,4).^2),500);  
lower = movmean(av_all_episodes(:,4) - sqrt(av_all_episodes(:,10)-av_all_episodes(:,4).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,4) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Profit of AM')
xlabel('Episodes')

ylim([-1,1]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_OA_7_b.png');
saveas(figure(5), [pwd filename]);
close(figure(5))

%Panel D: AVERAGE PROFIT OF OM OVER EPISODES
figure(6)

% plot average profit of player 2
x = (1:T)';
plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared profit of OM is in column 11
upper = movmean(av_all_episodes(:,5) + sqrt(av_all_episodes(:,11)-av_all_episodes(:,5).^2),500);  
lower = movmean(av_all_episodes(:,5) - sqrt(av_all_episodes(:,11)-av_all_episodes(:,5).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Profit of OM')
xlabel('Episodes')

ylim([-1,3]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_OA_7_d.png');
saveas(figure(6), [pwd filename]);
close(figure(6))

hold off

%% Figure OA.8: Accommodation strategy

%Read the data generated by script_simulation_accommodation
last_episodes = readmatrix('Data/last_episodes_accommodation.txt');
av_all_episodes = readmatrix('Data/av_all_episodes_accommodation.txt');

%Panel A: PRICE OF AM IN LAST EPISODE - HISTOGRAM

figure(7);
    [C,~,ic] = unique(last_episodes(:,1));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xticks(0:1:15);  %Ticks when the tick size is 1
    xlim([grid_middle - grid_size*tick-(9/10)*tick, grid_middle + grid_size*tick+(9/10)*tick]);%the (9/10) is so that the bars at 2 and 8 (if any) do not appear clipped, 
    %without displaying 1 and 9 which are not on the grid
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Price of AM in last episode')

%save png
filename = sprintf('/Figures/Fig_OA_8_a.png'); 
saveas(figure(7), [pwd filename]);

close(figure(7))

%Panel C: PRICE OF OM IN LAST EPISODE - HISTOGRAM

figure(8);
    [C,~,ic] = unique(last_episodes(:,2));
    percentages = accumarray(ic, 1) / length(ic) * 100;
    bar(C, percentages);
    xticks(0:1:15);  %Ticks when the tick size is 1
    xlim([grid_middle - grid_size*tick-(9/10)*tick, grid_middle + grid_size*tick+(9/10)*tick]);%the (9/10) is so that the bars at 2 and 8 (if any) do not appear clipped, 
    %without displaying 1 and 9 which are not on the grid
    ylim([0 max(percentages)*1.1]);  % Add 10% space above the highest bar
    ylabel('Percentage (%)')
    xlabel('Price of OM in last episode')

%save png
filename = sprintf('/Figures/Fig_OA_8_c.png'); 
saveas(figure(8), [pwd filename]);

close(figure(8))

%Panel B: AVERAGE PROFIT OF AM OVER EPISODES
figure(9)

% plot average profit of player 1
x = (1:T)';
plot(x,av_all_episodes(:,4) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared profit of AM is in column 10
upper = movmean(av_all_episodes(:,4) + sqrt(av_all_episodes(:,10)-av_all_episodes(:,4).^2),500);  
lower = movmean(av_all_episodes(:,4) - sqrt(av_all_episodes(:,10)-av_all_episodes(:,4).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,4) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Profit of AM')
xlabel('Episodes')

ylim([-1,1]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_OA_8_b.png');
saveas(figure(9), [pwd filename]);
close(figure(9))

%Panel D: AVERAGE PROFIT OF OM OVER EPISODES
figure(10)

% plot average profit of player 2
x = (1:T)';
plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])
hold on

% plot intervals +/- one sd, with 500 episodes moving average
% the average squared profit of OM is in column 11
upper = movmean(av_all_episodes(:,5) + sqrt(av_all_episodes(:,11)-av_all_episodes(:,5).^2),500);  
lower = movmean(av_all_episodes(:,5) - sqrt(av_all_episodes(:,11)-av_all_episodes(:,5).^2),500);  
plot(x,upper)
plot(x,lower)
%highlight the interval
fill([x; flipud(x)], [upper; flipud(lower)], [0.9 0.9 0.9]);

plot(x,av_all_episodes(:,5) ,'color',[0.8 0.4 0])

% set legend
legend('', '', 'Average', '$\pm$ 1 s.d.', 'interpreter', 'latex', 'location', 'northeast')
legend('boxoff')
ylabel('Profit of OM')
xlabel('Episodes')

ylim([-1,3]);

%hide right and top figure borders
ax = gca;
ax.Box = 'off';

%save png
filename = sprintf('/Figures/Fig_OA_8_d.png');
saveas(figure(10), [pwd filename]);
close(figure(10))

hold off